/*
Script to Create Inpatient tables 
--------------------

MSSR_Census501Diagnosis
MSSR_CensusDiagnosis
MSSR_CensusICDProcedure

MSSR_InpatientDiagonsis
MSSR_InpatientDischargeDiagnosis
MSSR_InpatientFeeDiagnosis
MSSR_INPATIENTS
*/

USE [V5_Registry]
GO
/****** Object:  Table [MSSR].[MSSR_INPATIENTS]    Script Date: 05/30/2014 14:05:40 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [MSSR].[MSSR_INPATIENTS](
	[PatientICN] [int] NULL,
	[PatientSID] [int] NULL,
	[InpatientSID] [bigint] NULL,
	[PTFIEN] [varchar](50) NULL,
	[Sta3n] [smallint] NULL,
	[MeansTestIndicator] [varchar](50) NULL,
	[AdmitDateTime] [datetime2](0) NULL,
	[AdmitVistaErrorDate] [varchar](50) NULL,
	[AdmitDateTimeTransformSID] [bigint] NULL,
	[AdmitDateSID] [int] NULL,
	[AdmitSourceSID] [int] NULL,
	[AdmitEligibilitySID] [int] NULL,
	[TransferFromFacility] [smallint] NULL,
	[TransferFromFacilitySuffix] [varchar](50) NULL,
	[SourceOfPayment] [varchar](50) NULL,
	[SuicideSelfInflict] [varchar](50) NULL,
	[PsychSeverity] [varchar](50) NULL,
	[PsychFunctional] [int] NULL,
	[PsychHighLevel] [int] NULL,
	[TransmissionStatus] [varchar](50) NULL,
	[DischargeFromFacility] [smallint] NULL,
	[DischargeFromFacilitySuffix] [varchar](50) NULL,
	[DischargeDateTime] [datetime2](0) NULL,
	[DischargeVistaErrorDate] [varchar](50) NULL,
	[DischargeDateTimeTransformSID] [bigint] NULL,
	[DischargeDateSID] [int] NULL,
	[DischargeStatus] [varchar](50) NULL,
	[OutpatientReferralFlag] [varchar](1) NULL,
	[DispositionType] [varchar](50) NULL,
	[PlaceOfDispositionSID] [int] NULL,
	[TransferToFacility] [smallint] NULL,
	[TransferToFacilitySuffix] [varchar](50) NULL,
	[ASIHDays] [smallint] NULL,
	[CPStatus] [varchar](50) NULL,
	[AbusedSubstanceSID] [int] NULL,
	[PrincipalDiagnosisICD9SID] [int] NULL,
	[PrincipalDiagnosisICD10SID] [int] NULL,
	[AdmitMASMovementTypeSID] [int] NULL,
	[AdmitFacilityMovementTypeSID] [int] NULL,
	[AdmitFromInstitutionSID] [int] NULL,
	[AdmitWardLocationSID] [int] NULL,
	[AdmitRoomBedSID] [int] NULL,
	[AdmitDiagnosis] [varchar](50) NULL,
	[AdmitForServiceConnectedFlag] [varchar](1) NULL,
	[AdmitRegulationSID] [int] NULL,
	[AdmitASIHSequence] [smallint] NULL,
	[ScheduledAdmissionFlag] [varchar](1) NULL,
	[AdmitEnteredByStaffSID] [int] NULL,
	[AdmitEnteredOnDateTime] [datetime2](0) NULL,
	[AdmitLastEditedByStaffSID] [int] NULL,
	[AdmitLastEditedOnDateTime] [datetime2](0) NULL,
	[DischargeMASMovementTypeSID] [int] NULL,
	[DischargeFacilityMovementTypeSID] [int] NULL,
	[DischargeToInstitutionSID] [int] NULL,
	[DischargeAttendingPhysicianSID] [int] NULL,
	[DischargeASIHSequence] [smallint] NULL,
	[DischargeEnteredByStaffSID] [int] NULL,
	[DischargeEnteredOnDateTime] [datetime2](0) NULL,
	[DischargeLastEditedByStaffSID] [int] NULL,
	[DischargeLastEditedOnDateTime] [datetime2](0) NULL,
	[SpecialtyCDR] [smallint] NULL,
	[TransmitFlag] [varchar](1) NULL,
	[DischargeFromSpecialtySID] [int] NULL,
	[DischargeFromService] [varchar](50) NULL,
	[DischargeDRGSID] [int] NULL,
	[LOSInService] [smallint] NULL,
	[LOSCumulative] [smallint] NULL,
	[ProviderSID] [int] NULL,
	[DischargeSuicideSelfInflict] [varchar](50) NULL,
	[DischargePsychSeverity] [varchar](50) NULL,
	[DischargePsychFunctional] [smallint] NULL,
	[DischargePsychHighLevel] [smallint] NULL,
	[LeaveDays] [smallint] NULL,
	[DischargeAbusedSubstanceSID] [int] NULL,
	[PassDays] [smallint] NULL,
	[FirstClosedOutDateTime] [datetime2](0) NULL,
	[FirstClosedOutVistaErrorDate] [varchar](50) NULL,
	[FirstClosedOutDateTimeTransformSID] [bigint] NULL,
	[AgentOrangeFlag] [varchar](1) NULL,
	[CombatFlag] [varchar](1) NULL,
	[HeadNeckCancerFlag] [varchar](1) NULL,
	[IonizingRadiationFlag] [varchar](1) NULL,
	[LegionnairesDiseaseFlag] [varchar](1) NULL,
	[MilitarySexualTraumaFlag] [varchar](1) NULL,
	[ServiceConnectedFlag] [varchar](1) NULL,
	[SHADFlag] [varchar](1) NULL,
	[SWAsiaConditionsFlag] [varchar](1) NULL,
	[DischargeWardLocationSID] [int] NULL,
	[DischargeWardCDR] [int] NULL,
	[DischargeSpecialtySID] [int] NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [MSSR].[MSSR_InpatientFeeDiagnosis]    Script Date: 05/30/2014 14:05:40 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [MSSR].[MSSR_InpatientFeeDiagnosis](
	[InpatientFeeDiagnosisSID] [bigint] NULL,
	[PTFIEN] [varchar](50) NULL,
	[Sta3n] [smallint] NULL,
	[OrdinalNumber] [smallint] NULL,
	[InpatientFeeBasisSID] [bigint] NULL,
	[PatientSID] [int] NULL,
	[PatientICN] [int] NULL,
	[AdmitDateTime] [datetime2](0) NULL,
	[AdmitVistaErrorDate] [varchar](50) NULL,
	[AdmitDateTimeTransformSID] [bigint] NULL,
	[AdmitDateSID] [int] NULL,
	[DischargeDateTime] [datetime2](0) NULL,
	[DischargeVistaErrorDate] [varchar](50) NULL,
	[DischargeDateTimeTransformSID] [bigint] NULL,
	[DischargeDateSID] [int] NULL,
	[ICD9SID] [int] NULL,
	[ICD10SID] [int] NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [MSSR].[MSSR_InpatientDischargeDiagnosis]    Script Date: 05/30/2014 14:05:40 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [MSSR].[MSSR_InpatientDischargeDiagnosis](
	[InpatientDischargeDiagnosisSID] [bigint] NULL,
	[PTFIEN] [varchar](50) NULL,
	[PTFChild_45_02IEN] [varchar](50) NULL,
	[Sta3n] [smallint] NULL,
	[OrdinalNumber] [smallint] NULL,
	[InpatientSID] [bigint] NULL,
	[PatientSID] [int] NULL,
	[PatientICN] [int] NULL,
	[AdmitDateTime] [datetime2](0) NULL,
	[AdmitVistaErrorDate] [varchar](50) NULL,
	[AdmitDateTimeTransformSID] [bigint] NULL,
	[DischargeDateTime] [datetime2](0) NULL,
	[DischargeVistaErrorDate] [varchar](50) NULL,
	[DischargeDateTimeTransformSID] [bigint] NULL,
	[DischargeDateSID] [int] NULL,
	[ICD9SID] [int] NULL,
	[ICD10SID] [int] NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [MSSR].[MSSR_InpatientDiagonsis]    Script Date: 05/30/2014 14:05:40 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [MSSR].[MSSR_InpatientDiagonsis](
	[InpatientDiagnosisSID] [bigint] NULL,
	[PTFIEN] [varchar](50) NULL,
	[Sta3n] [smallint] NULL,
	[OrdinalNumber] [smallint] NULL,
	[PatientICN] [int] NULL,
	[InpatientSID] [bigint] NULL,
	[PatientSID] [int] NULL,
	[AdmitDateTime] [datetime2](0) NULL,
	[AdmitVistaErrorDate] [varchar](50) NULL,
	[AdmitDateTimeTransformSID] [bigint] NULL,
	[AdmitDateSID] [int] NULL,
	[DischargeDateTime] [datetime2](0) NULL,
	[DischargeVistaErrorDate] [varchar](50) NULL,
	[DischargeDateTimeTransformSID] [bigint] NULL,
	[DischargeDateSID] [int] NULL,
	[ICD9SID] [int] NULL,
	[ICD10SID] [int] NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [MSSR].[MSSR_CensusICDProcedure]    Script Date: 05/30/2014 14:05:40 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [MSSR].[MSSR_CensusICDProcedure](
	[CensusICDProcedureSID] [bigint] NULL,
	[PTFIEN] [varchar](50) NULL,
	[PTFChild_45_05IEN] [varchar](50) NULL,
	[OrdinalNumber] [smallint] NULL,
	[Sta3n] [smallint] NULL,
	[CensusSID] [bigint] NULL,
	[PatientICN] [int] NULL,
	[PatientSID] [int] NULL,
	[ParentFeeBasisFlag] [varchar](1) NULL,
	[AdmitDateTime] [datetime2](0) NULL,
	[AdmitVistaErrorDate] [varchar](50) NULL,
	[AdmitDateTimeTransformSID] [bigint] NULL,
	[AdmitDateSID] [int] NULL,
	[CensusDateTime] [datetime2](0) NULL,
	[CensusVistaErrorDate] [varchar](50) NULL,
	[CensusDateTimeTransformSID] [bigint] NULL,
	[CensusDateSID] [int] NULL,
	[ICD9ProcedureSID] [int] NULL,
	[ICD10ProcedureSID] [int] NULL,
	[ICDProcedureDateTime] [datetime2](0) NULL,
	[ICDProcedureVistaErrorDate] [varchar](50) NULL,
	[ICDProcedureDateTimeTransformSID] [bigint] NULL,
	[ICDProcedureDateSID] [int] NULL,
	[DialysisTreatmentCount] [smallint] NULL,
	[DialysisTypeSID] [int] NULL,
	[SpecialtySID] [int] NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [MSSR].[MSSR_CensusDiagnosis]    Script Date: 05/30/2014 14:05:40 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [MSSR].[MSSR_CensusDiagnosis](
	[CensusDiagnosisSID] [bigint] NULL,
	[PTFIEN] [varchar](50) NULL,
	[OrdinalNumber] [smallint] NULL,
	[Sta3n] [smallint] NULL,
	[CensusSID] [bigint] NULL,
	[PatientSID] [int] NULL,
	[PatientICN] [int] NULL,
	[ParentFeeBasisFlag] [varchar](1) NULL,
	[AdmitDateTime] [datetime2](0) NULL,
	[AdmitVistaErrorDate] [varchar](50) NULL,
	[AdmitDateTimeTransformSID] [bigint] NULL,
	[AdmitDateSID] [int] NULL,
	[CensusDateTime] [datetime2](0) NULL,
	[CensusVistaErrorDate] [varchar](50) NULL,
	[CensusDateTimeTransformSID] [bigint] NULL,
	[CensusDateSID] [int] NULL,
	[ICD9SID] [int] NULL,
	[ICD10SID] [int] NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [MSSR].[MSSR_Census501Diagnosis]    Script Date: 05/30/2014 14:05:40 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [MSSR].[MSSR_Census501Diagnosis](
	[Census501DiagnosisSID] [bigint] NULL,
	[PTFIEN] [varchar](50) NULL,
	[PTFChild_45_02IEN] [varchar](50) NULL,
	[OrdinalNumber] [smallint] NULL,
	[Sta3n] [smallint] NULL,
	[CensusSID] [bigint] NULL,
	[Census501SID] [bigint] NULL,
	[PatientSID] [int] NULL,
	[PatientICN] [int] NULL,
	[ParentFeeBasisFlag] [varchar](1) NULL,
	[AdmitDateTime] [datetime2](0) NULL,
	[AdmitVistaErrorDate] [varchar](50) NULL,
	[AdmitDateTimeTransformSID] [bigint] NULL,
	[AdmitDateSID] [int] NULL,
	[CensusDateTime] [datetime2](0) NULL,
	[CensusVistaErrorDate] [varchar](50) NULL,
	[CensusDateTimeTransformSID] [bigint] NULL,
	[CensusDateSID] [int] NULL,
	[ICD9SID] [int] NULL,
	[ICD10SID] [int] NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
